<?php
// =============================
//   CONFIGURAÇÃO DO ARQUIVO
// =============================
$m3uUrl = "http://ipst.store/get.php?username=715735356&password=450424809&type=m3u_plus&output=m3u8"; // coloque o caminho da sua lista
$m3u = file_exists($m3uUrl) ? file($m3uUrl) : [];

$conteudo = [];
$tipoFiltro = $_GET['tipo'] ?? 'todos';
$busca = strtolower($_GET['busca'] ?? '');

$tempItem = null;

// =============================
//   LEITURA DO M3U
// =============================
foreach ($m3u as $linha) {
    $linha = trim($linha);

    if (str_starts_with($linha, "#EXTINF")) {

        preg_match('/tvg-name="([^"]*)"/', $linha, $name);
        preg_match('/tvg-logo="([^"]*)"/', $linha, $logo);
        preg_match('/group-title="([^"]*)"/', $linha, $group);

        $tempItem = [
            "nome"  => $name[1] ?? "Sem nome",
            "logo"  => $logo[1] ?? "",
            "grupo" => $group[1] ?? "",
            "link"  => "",
            "tipo"  => "desconhecido"
        ];
    }

    if (!str_starts_with($linha, "#") && $tempItem) {

        // Identificar tipo corretamente
        if (strpos($linha, "/movie/") !== false) {
            $tempItem["tipo"] = "filme";
        } elseif (strpos($linha, "/series/") !== false) {
            $tempItem["tipo"] = "serie";
        } elseif (strpos($linha, ".m3u8") !== false) {
            $tempItem["tipo"] = "canal";
        }

        $tempItem["link"] = $linha;
        $conteudo[] = $tempItem;
        $tempItem = null;
    }
}

// =============================
//   FILTRAGEM
// =============================
$lista = array_filter($conteudo, function ($item) use ($tipoFiltro, $busca) {

    if ($tipoFiltro !== 'todos' && $item['tipo'] !== $tipoFiltro) {
        return false;
    }

    if ($busca !== '' && !str_contains(strtolower($item['nome']), $busca)) {
        return false;
    }

    return true;
});

$contar = [
    "filmes" => count(array_filter($conteudo, fn($i) => $i['tipo'] === 'filme')),
    "series" => count(array_filter($conteudo, fn($i) => $i['tipo'] === 'serie')),
    "canais" => count(array_filter($conteudo, fn($i) => $i['tipo'] === 'canal')),
    "total"  => count($conteudo)
];

?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
<meta charset="UTF-8">
<title>Leitor M3U</title>
<style>
body{
    background:#0d0d0d;
    color:#fff;
    font-family:sans-serif;
    padding:15px;
}
.header{
    display:flex;
    gap:10px;
    overflow-x:auto;
    padding-bottom:10px;
}
.header button{
    background:#1a1a1a;
    color:#fff;
    border:none;
    padding:10px 15px;
    border-radius:5px;
    white-space:nowrap;
}
.header button.active{
    background:red;
}
input{
    width:100%;
    padding:12px;
    margin:10px 0;
    border-radius:5px;
    border:none;
}
.grid{
    display:grid;
    grid-template-columns:repeat(auto-fill, minmax(130px,1fr));
    gap:12px;
}
.item{
    background:#1a1a1a;
    padding:10px;
    border-radius:6px;
    text-align:center;
}
.item img{
    width:100%;
    height:180px;
    object-fit:cover;
    border-radius:5px;
}
.tipo{
    font-size:12px;
    opacity:0.6;
}
</style>
</head>
<body>

<!-- AQUI ENTRA SEU HEADER DEPOIS -->

<h2>Conteúdos Encontrados (<?= $contar['total'] ?>)</h2>
<p>
    Filmes: <?= $contar['filmes'] ?> |
    Séries: <?= $contar['series'] ?> |
    Canais: <?= $contar['canais'] ?>
</p>

<!-- FILTROS -->
<div class="header">
    <a href="?tipo=todos"><button class="<?= $tipoFiltro=='todos'?'active':'' ?>">Todos</button></a>
    <a href="?tipo=filme"><button class="<?= $tipoFiltro=='filme'?'active':'' ?>">Filmes</button></a>
    <a href="?tipo=serie"><button class="<?= $tipoFiltro=='serie'?'active':'' ?>">Séries</button></a>
    <a href="?tipo=canal"><button class="<?= $tipoFiltro=='canal'?'active':'' ?>">Canais</button></a>
</div>

<!-- BUSCA -->
<form method="GET">
    <input type="hidden" name="tipo" value="<?= $tipoFiltro ?>">
    <input type="text" name="busca" placeholder="Buscar..." value="<?= htmlspecialchars($busca) ?>">
</form>

<!-- GRID -->
<div class="grid">
<?php foreach ($lista as $item): ?>
    <div class="item">
        <img src="<?= $item['logo'] ?>" onerror="this.src='https://via.placeholder.com/300x450?text=Sem+Capa';">
        <div class="nome"><?= $item['nome'] ?></div>
        <div class="tipo"><?= strtoupper($item['tipo']) ?></div>
    </div>
<?php endforeach; ?>
</div>

</body>
</html>