<?php
session_start();

if(!isset($_SESSION['adm_id'])){
    echo json_encode(['success' => false, 'msg' => 'Não autorizado']);
    exit;
}

$avisosDir = __DIR__."/avisos";
if(!is_dir($avisosDir)) mkdir($avisosDir,0755);
$avisosFile = $avisosDir."/avisos.json";

$avisos = file_exists($avisosFile) ? json_decode(file_get_contents($avisosFile), true) : [];

$tipo = $_POST['tipo'] ?? '';
$titulo_opcional = $_POST['titulo_opcional'] ?? '';
$descricao_opcional = $_POST['descricao_opcional'] ?? '';
$link_opcional = $_POST['link_opcional'] ?? '';

if (empty($tipo)) {
    echo json_encode(['success' => false, 'msg' => 'Tipo de aviso não especificado']);
    exit;
}

$novoAviso = [
    'id' => uniqid(), // Garante um ID único
    'tipo' => $tipo,
];

if (!empty($titulo_opcional)) $novoAviso['titulo_opcional'] = $titulo_opcional;
if (!empty($descricao_opcional)) $novoAviso['descricao_opcional'] = $descricao_opcional;
if (!empty($link_opcional)) $novoAviso['link_opcional'] = $link_opcional;

if ($tipo === 'normal') {

    // 🔥 Adicionar os dois novos campos opcionais
    if (!empty($_POST["rodape_opcional"])) {
        $novoAviso["rodape_opcional"] = $_POST["rodape_opcional"];
    }
    if (!empty($_POST["botao_nome_opcional"])) {
        $novoAviso["botao_nome_opcional"] = $_POST["botao_nome_opcional"];
    }

    $uploadDir = __DIR__."/uploads/";
    if(!is_dir($uploadDir)) mkdir($uploadDir,0755);

    if (isset($_FILES['arquivo']) && $_FILES['arquivo']['error'] === UPLOAD_ERR_OK) {
        $fileTmpPath = $_FILES['arquivo']['tmp_name'];
        $fileName = $_FILES['arquivo']['name'];
        $fileExtension = strtolower(pathinfo($fileName, PATHINFO_EXTENSION));
        $newFileName = uniqid() . '.' . $fileExtension;
        $destPath = $uploadDir . $newFileName;

        if(move_uploaded_file($fileTmpPath, $destPath)) {
            $novoAviso['imagem'] = $newFileName;
        } else {
            echo json_encode(['success' => false, 'msg' => 'Falha ao mover o arquivo de upload']);
            exit;
        }
    }
} elseif ($tipo === 'filme' || $tipo === 'serie') {
    $conteudoJson = $_POST['conteudo'] ?? '';
    if (empty($conteudoJson)) {
        echo json_encode(['success' => false, 'msg' => 'Conteúdo TMDB não especificado']);
        exit;
    }
    $novoAviso['conteudo'] = json_decode($conteudoJson, true);
}

$avisos[] = $novoAviso;

if (file_put_contents($avisosFile, json_encode($avisos, JSON_PRETTY_PRINT))) {
    echo json_encode(['success' => true]);
} else {
    echo json_encode(['success' => false, 'msg' => 'Falha ao salvar o arquivo JSON']);
}
?>
