<?php  
session_start();  
include "includes/header.php";  
  
$pedidosFile = __DIR__."/../pedidos/pedidos.json";  
$reportesFile = __DIR__."/../pedidos/reportes.json";  
  
$pedidos = file_exists($pedidosFile) ? json_decode(file_get_contents($pedidosFile), true) : [];  
$reportes = file_exists($reportesFile) ? json_decode(file_get_contents($reportesFile), true) : [];  

function getCapa($item){  
    if (!empty($item['capa'])) return $item['capa'];  
    if (!empty($item['relacionado']['capa'])) return $item['relacionado']['capa'];  
    if (!empty($item['canal'])) return "canais/".strtolower($item['canal']).".png";  
    return "/imagens/default.png";  
}  

function statusInfo($tipo, $status){  
    $status = strtolower($status);  
    if($tipo === "pedido"){  
        switch($status){  
            case "pendente": return ["Pedido Pendente", "#facc15", "fa-hourglass-half"];  
            case "processando": return ["Em Andamento", "#3b82f6", "fa-spinner fa-spin"];  
            case "concluido": return ["Conteúdo Disponível", "#10b981", "fa-check-circle"];  
            case "cancelado": return ["Pedido Negado", "#ef4444", "fa-times-circle"];  
        }  
    } else {  
        switch($status){  
            case "pendente": return ["Pendente", "#facc15", "fa-hourglass-half"];  
            case "processando": return ["Resolvendo Problema", "#3b82f6", "fa-spinner fa-spin"];  
            case "concluido": return ["Problema Resolvido", "#10b981", "fa-check-circle"];  
            case "cancelado": return ["Cancelado", "#ef4444", "fa-times-circle"];  
        }  
    }  
    return [$status, "#999", "fa-question-circle"];  
}  

// Contagem por status para pedidos
$statusPedidos = [
    "pendente" => 0,
    "processando" => 0,
    "concluido" => 0,
    "cancelado" => 0
];
foreach($pedidos as $p){
    $status = strtolower($p['status'] ?? 'pendente');
    if(isset($statusPedidos[$status])) $statusPedidos[$status]++;
}

// Contagem por status para problemas
$statusProblemas = [
    "pendente" => 0,
    "processando" => 0,
    "concluido" => 0,
    "cancelado" => 0
];
foreach($reportes as $r){
    $status = strtolower($r['status'] ?? 'pendente');
    if(isset($statusProblemas[$status])) $statusProblemas[$status]++;
}
?>  

<div class="pt-28 px-5 max-w-3xl mx-auto">

<div class="grid grid-cols-2 gap-4 mb-6">
    <div class="cardResumo">
        <h3><i class="fa-solid fa-cart-shopping"></i> Total de Pedidos</h3>
        <p><?= count($pedidos) ?></p>
        <p style="color:#facc15;">Pendentes: <?= $statusPedidos['pendente'] ?></p>
        <p style="color:#3b82f6;">Processando: <?= $statusPedidos['processando'] ?></p>
        <p style="color:#10b981;">Disponível: <?= $statusPedidos['concluido'] ?></p>
        <p style="color:#ef4444;">Cancelado: <?= $statusPedidos['cancelado'] ?></p>
    </div>

    <div class="cardResumo">
        <h3><i class="fa-solid fa-triangle-exclamation"></i> Total de Problemas</h3>
        <p><?= count($reportes) ?></p>
        <p style="color:#facc15;">Pendentes: <?= $statusProblemas['pendente'] ?></p>
        <p style="color:#3b82f6;">Resolvendo: <?= $statusProblemas['processando'] ?></p>
        <p style="color:#10b981;">Resolvido: <?= $statusProblemas['concluido'] ?></p>
        <p style="color:#ef4444;">Cancelado: <?= $statusProblemas['cancelado'] ?></p>
    </div>
</div>

<div class="mb-4">
    <button id="verificarPedidosBtn" class="btn-full green">
        <i class="fa fa-check-circle"></i> Verificar Pedidos
    </button>
</div>

<h1 class="text-2xl font-bold mb-6 text-center">
    <i class="fa-solid fa-list-check mr-2"></i>Gerenciar Pedidos
</h1>

<!-- Filtros -->
<select id="tipoFiltro" class="select-filter mb-3">  
    <option value="todos">Mostrar todos</option>  
    <option value="pedido">Pedidos</option>  
    <option value="problema">Problemas</option>  
</select>  

<select id="statusFiltro" class="select-filter mb-3">  
    <option value="todos">Todos os Status</option>
    <option value="pendente">Pendente</option>
    <option value="processando">Processando/Resolvendo</option>
    <option value="concluido">Disponível/Resolvido</option>
    <option value="cancelado">Cancelado</option>
</select>  

<div id="listaPedidos" class="flex flex-col gap-4">  

<?php    
foreach ($pedidos as $item){ renderItem($item, "pedido"); }  
foreach ($reportes as $item){ renderItem($item, "problema"); }  

function renderItem($item, $tipo){  
    $capa = getCapa($item);  
    $nome = $item['nome'] ?? $item['relacionado']['nome'] ?? 'Sem nome';  
    $desc = $item['descricao'] ?? '';  
    $status = $item['status'] ?? 'pendente';  
    $created = $item['created_at'] ?? '';  

    [$statusText, $statusColor, $statusIcon] = statusInfo($tipo, $status);  
?>  

    <div class="item" data-tipo="<?= $tipo ?>" data-status="<?= strtolower($status) ?>">  
        <div class="thumb-wrapper">  
            <img src="<?= $capa ?>" class="thumb">  
        </div>  

        <div class="info">  
            <div class="status-container">
                <div class="status" style="background: <?= $statusColor ?>;">
                    <i class="fa <?= $statusIcon ?>"></i> <?= $statusText ?>
                </div>
            </div>

            <h3 class="nome"><?= htmlspecialchars($nome) ?></h3>

            <?php if($desc): ?>  
            <p class="descricao"><i class="fa fa-comment"></i> <?= htmlspecialchars($desc) ?></p>  
            <?php endif; ?>  

            <p class="created"><i class="fa fa-clock"></i> <?= $created ?></p>  

            <div class="botoes">  
                <button class="btn green" onclick="alterarStatus('<?= $nome ?>','concluido','<?= $capa ?>','<?= $statusText ?>')"><i class="fa fa-check"></i></button>
                <button class="btn blue" onclick="alterarStatus('<?= $nome ?>','processando','<?= $capa ?>','<?= $statusText ?>')"><i class="fa fa-spinner"></i></button>          
                <button class="btn gray" onclick="alterarStatus('<?= $nome ?>','cancelado','<?= $capa ?>','<?= $statusText ?>')"><i class="fa fa-ban"></i></button>
                <button class="btn red" onclick="deletarPedido('<?= $nome ?>','<?= $capa ?>')"><i class="fa fa-trash"></i></button>
            </div>  
        </div>  
    </div>  

<?php } ?>  
</div>
</div>  

<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>  

<script>
document.getElementById("tipoFiltro").addEventListener("change", filtrar);
document.getElementById("statusFiltro").addEventListener("change", filtrar);

function filtrar() {
    let tipo = document.getElementById("tipoFiltro").value;
    let status = document.getElementById("statusFiltro").value;

    document.querySelectorAll(".item").forEach(i => {
        let mostraTipo = tipo === "todos" || i.dataset.tipo === tipo;
        let mostraStatus = status === "todos" || i.dataset.status === status;
        i.style.display = (mostraTipo && mostraStatus) ? "flex" : "none";
    });
}

function alterarStatus(nome, novoStatus, capa, statusAtual){  
    Swal.fire({  
        title: "Alterar Status?",  
        html: `
        <div style="display:flex;align-items:center;gap:10px;background:#000;padding:10px;border-radius:10px;">
            <img src="${capa}" style="width:80px;height:80px;border-radius:10px;object-fit:contain;background:#000;">
            <div style="text-align:left;color:#fff">
                <p><b>${nome}</b></p>
                <p>De: <span style="color:#facc15;">${statusAtual}</span></p>
                <p>Para: <span style="color:#3b82f6;">${novoStatus}</span></p>
            </div>
        </div>
        `,  
        showCancelButton: true,  
        confirmButtonText: "Sim",  
        cancelButtonText: "Cancelar",  
        background: getComputedStyle(document.documentElement).getPropertyValue('--menu-secondary') || '#111',  
        color: getComputedStyle(document.documentElement).getPropertyValue('--text-primary') || '#000',  
        backdrop: 'rgba(0,0,0,1)',  
        icon: "question",  
    }).then(res=>{  
        if(res.isConfirmed){  
            fetch("alterar_status.php", {  
                method:"POST",  
                headers:{"Content-Type":"application/json"},  
                body: JSON.stringify({nome, novoStatus})  
            }).then(()=>location.reload());  
        }  
    });  
}  

function deletarPedido(nome, capa){  
    Swal.fire({  
        title:"Excluir?",  
        html: `
        <div style="display:flex;align-items:center;gap:10px;background:#000;padding:10px;border-radius:10px;">
            <img src="${capa}" style="width:80px;height:80px;border-radius:10px;object-fit:contain;background:#000;">
            <div style="text-align:left;color:#fff">
                <p>Deseja excluir <b>${nome}</b>?</p>
                <p>Isso não poderá ser desfeito!</p>
            </div>
        </div>
        `,  
        icon:"warning",  
        showCancelButton:true,  
        confirmButtonText:"Excluir",  
        cancelButtonText:"Cancelar",  
        background: getComputedStyle(document.documentElement).getPropertyValue('--menu-secondary') || '#111',  
        color: getComputedStyle(document.documentElement).getPropertyValue('--text-primary') || '#000',  
        backdrop: 'rgba(0,0,0,1)'  
    }).then(res=>{  
        if(res.isConfirmed){  
            fetch("delete_pedido.php", {  
                method:"POST",  
                headers:{"Content-Type":"application/json"},  
                body: JSON.stringify({nome})  
            }).then(()=>location.reload());  
        }
    });  
}
document.getElementById("verificarPedidosBtn").addEventListener("click", function(){
    const textColor = getComputedStyle(document.documentElement).getPropertyValue('--text-primary') || '#fff';
    const bgColor = getComputedStyle(document.documentElement).getPropertyValue('--menu-secondary') || '#111';
    const greenColor = getComputedStyle(document.documentElement).getPropertyValue('--green') || '#10b981';

    // Loading
    Swal.fire({
        title: `<span style="color:${textColor}">Verificando pedidos...</span>`,
        html: `
            <div style="display:flex; flex-direction:column; align-items:center; gap:15px; color: ${textColor};">
                <i class='fa fa-spinner fa-spin' style='font-size:40px;color:${greenColor};'></i>
                <span style="font-weight:bold;">Aguardando...</span>
            </div>
        `,
        allowOutsideClick: false,
        showConfirmButton: false,
        backdrop: 'rgba(0,0,0,1)',
        background: bgColor,
        didOpen: () => {
            Swal.showLoading();

            fetch("verificar_pedidos.php")
            .then(res => res.json())
            .then(data => {
                Swal.close(); // fecha o loading

                const createCard = (title, items, color) => {
    const count = items.length;
    if(count === 0) items = ["Nenhum"];
    return `
        <div style="
            background:${color};
            padding:15px;
            border-radius:12px;
            margin-bottom:10px;
            flex:1 1 200px;
            min-width:180px;
            cursor:default;
        ">
            <h4 style="margin:0 0 5px;font-weight:bold;color:${textColor};display:flex;justify-content:space-between;align-items:center;">
                <span>${title}</span>
                <span style='font-size:12px;background:rgba(255,255,255,0.2);padding:2px 6px;border-radius:8px;'>${count}</span>
            </h4>
            <ul style="padding-left:20px;margin:0;font-size:14px;color:${textColor}; max-height:150px; overflow-y:auto;">
                ${items.map(i=>`<li>${i}</li>`).join('')}
            </ul>
        </div>
    `;
};

const html = `
    <div style="display:flex;flex-wrap:wrap;gap:12px;max-height:400px;overflow-y:auto;">
        ${createCard("Filmes Aprovados", data.aprovados.filmes, "#10b981")}
        ${createCard("Séries Aprovadas", data.aprovados.series, "#10b981")}
        ${createCard("Filmes Não Aprovados", data.naoAprovados.filmes, "#ef4444")}
        ${createCard("Séries Não Aprovadas", data.naoAprovados.series, "#ef4444")}
    </div>
`;

Swal.fire({
    title: `<span style="color:${textColor}">Pedidos Verificados</span>`,
    icon: "success",
    html: html,
    width: '95%',
    showCloseButton: true,
    background: bgColor,
    color: textColor,
    scrollbarPadding: false,
    backdrop: 'rgba(0,0,0,1)',
    confirmButtonText: "Ok",
    allowOutsideClick: false
}).then(() => {
    location.reload(); // Atualiza a página ao clicar em Ok
});

            })
            .catch(err => {
                console.error(err);
                Swal.fire({
                    title: `<span style="color:${textColor}">Erro</span>`,
                    text: "Não foi possível verificar os pedidos.",
                    icon: "error",
                    confirmButtonText: "Ok",
                    background: bgColor,
                    color: textColor,
                    backdrop: 'rgba(0,0,0,1)'
                });
            });
        }
    });
});
</script>

<style>
.btn-full {
    width: 100%;            /* largura total */
    padding: 14px 20px;     /* mais confortável para o texto */
    border-radius: 12px;
    font-size: 16px;
    font-weight: bold;
    display: flex;
    align-items: center;
    justify-content: center;
    gap: 8px;
    cursor: pointer;
    transition: background 0.3s, transform 0.2s;
}

.btn-full.green {
    background: #10b981;
    color: #fff;
}

.btn-full:hover {
    transform: translateY(-2px);
    filter: brightness(1.1);
}
.cardResumo { background: var(--menu-secondary); border: 2px solid var(--border-color); padding: 20px; border-radius: 14px; text-align: center; }
.cardResumo h3 { font-size: 14px; font-weight: 700; opacity: 0.9; margin-bottom: 6px; }
.cardResumo h3 i { margin-right: 6px; }
.cardResumo p { font-size: 16px; font-weight: bold; margin:2px 0; }

.item { display:flex; gap:16px; padding:20px; border-radius:14px; border:2px solid var(--border-color); background:var(--menu-secondary); color:var(--text-primary); position:relative; }
.thumb-wrapper { position:relative; flex-shrink:0; }
.thumb { width:130px; height:130px; object-fit:contain; border-radius:10px; background:#000; }
.info { flex:1; display:flex; flex-direction:column; gap:6px; position:relative; }
.status-container { position:relative; }
.status { position:absolute; top:0; right:0; display:flex; align-items:center; gap:6px; padding:5px 12px; font-size:13px; font-weight:bold; border-radius:8px; color:#fff; white-space:nowrap; }
.nome { font-size:18px; font-weight:700; line-height:1.3; word-wrap:break-word; margin-top:24px; } 
.descricao { font-size:14px; opacity:.9; }
.created { font-size:12px; opacity:.8; }
.botoes { margin-top:12px; display:flex; flex-wrap:wrap; gap:10px; }
.btn { border:none; padding:10px; border-radius:10px; color:#fff; width:40px; height:40px; display:flex; align-items:center; justify-content:center; }
.green { background:#10b981; } .blue { background:#3b82f6; } .yellow{ background:#facc15; color:#000; } .gray{ background:#6b7280; } .red { background:#ef4444; }
.select-filter { width:100%; padding:12px; border-radius:12px; background:var(--menu-secondary); border:2px solid var(--border-color); color:var(--text-primary); }

@media (max-width:480px){
  .item { flex-direction:row; gap:12px; padding:16px; position:relative; }
  .thumb { width:110px; height:110px; object-fit:contain; }
  .info { flex:1; gap:5px; }
  .nome { font-size:15px; }
  .status { top:0; right:0; font-size:12px; padding:3px 8px; }
  .botoes { width:100%; margin-top:12px; display:grid; grid-template-columns:repeat(4,1fr); gap:8px; }
  .btn { width:100%; min-height:42px; padding:8px 0; font-size:16px; }
}
</style>