<?php
session_start();
include "includes/header.php";

if(!isset($_SESSION['adm_id'])){
    header("Location: login.php");
    exit;
}

$avisosDir = __DIR__."/avisos";
if(!is_dir($avisosDir)) mkdir($avisosDir,0755);
$avisosFile = $avisosDir."/avisos.json";

$avisos = file_exists($avisosFile) ? json_decode(file_get_contents($avisosFile), true) : [];
$avisos = array_reverse($avisos);
$uploadDir = __DIR__."/uploads/";
if(!is_dir($uploadDir)) mkdir($uploadDir,0755);
?>
<div class="pt-28 px-5 max-w-7xl mx-auto">
    <div class="rounded-2xl shadow-md p-6 bg-[var(--menu-bg)] border" style="border-color:var(--border-color);">
        <h1 class="text-3xl font-bold mb-6">Painel de Avisos</h1>

        <!-- FORMULÁRIO -->
<div class="mb-8 p-4 rounded-xl border bg-[var(--menu-secondary)]" style="border-color:var(--border-color);">
    <h2 class="text-xl font-semibold mb-2">Criar Aviso</h2>

    <label>Tipo de Aviso</label>
    <select id="tipoAviso" class="w-full mb-3 p-3 rounded border text-[var(--text-color)] bg-[var(--menu-secondary)] focus:outline-none focus:ring-2 focus:ring-[var(--accent)]" style="border-color:var(--border-color);">
        <option value="normal" class="bg-[var(--menu-secondary)] text-[var(--text-color)]">Aviso Normal</option>
        <option value="filme" class="bg-[var(--menu-secondary)] text-[var(--text-color)]">Filme</option>
        <option value="serie" class="bg-[var(--menu-secondary)] text-[var(--text-color)]">Série</option>
    </select>

    <!-- Campos Opcionais Comuns -->
    <label>Título Opcional</label>
    <input type="text" id="tituloOpcional" class="w-full mb-2 p-3 rounded border text-[var(--text-color)] bg-[var(--menu-secondary)] focus:outline-none focus:ring-2 focus:ring-[var(--accent)]" style="border-color:var(--border-color);">
    <label>Descrição Opcional</label>
    <textarea id="descOpcional" class="w-full mb-2 p-3 rounded border text-[var(--text-color)] bg-[var(--menu-secondary)] focus:outline-none focus:ring-2 focus:ring-[var(--accent)]" style="border-color:var(--border-color);"></textarea>
    <label>Link Opcional</label>
    <input type="url" id="linkOpcional" class="w-full mb-2 p-3 rounded border text-[var(--text-color)] bg-[var(--menu-secondary)] focus:outline-none focus:ring-2 focus:ring-[var(--accent)]" style="border-color:var(--border-color);" placeholder="https://exemplo.com/link-opcional">
    
    <label>Nome do Botão (Opcional)</label>
<input type="text" id="botaoNomeOpcional"
class="w-full mb-2 p-3 rounded border text-[var(--text-color)] bg-[var(--menu-secondary)]
focus:outline-none focus:ring-2 focus:ring-[var(--accent)]"
style="border-color:var(--border-color);" placeholder="Ex: Assistir agora">
    
    <label>Rodapé Opcional</label>
<input type="text" id="rodapeOpcional"
class="w-full mb-2 p-3 rounded border text-[var(--text-color)] bg-[var(--menu-secondary)]
focus:outline-none focus:ring-2 focus:ring-[var(--accent)]"
style="border-color:var(--border-color);">

    <!-- Normal -->
    <div id="normalForm">
        <label>Imagem/Video</label>
        <input type="file" id="arquivoNormal" accept="image/*,video/*" class="w-full mb-2 p-2 rounded border text-[var(--text-color)] bg-[var(--menu-secondary)]" style="border-color:var(--border-color);">
    </div>

    <!-- TMDB -->
    <div id="tmdbForm" style="display:none;">
        <label>Buscar Conteúdo (TMDB)</label>
        <input type="text" id="buscaTMDB" class="w-full mb-2 p-3 rounded border text-[var(--text-color)] bg-[var(--menu-secondary)] focus:outline-none focus:ring-2 focus:ring-[var(--accent)]" placeholder="Digite o nome" style="border-color:var(--border-color);">
        <div id="resultadoTMDB" class="grid gap-4 mt-2 grid-cols-2 md:grid-cols-4 xl:grid-cols-5"></div>
    </div>

    <!-- Prévia -->
    <div id="preVisual" class="mt-4 p-2 border rounded bg-[var(--menu-bg)]" style="display:none;"></div>

    <!-- Temporadas/Episódios (séries) -->
    <div id="seriesSeasons" style="display:none; margin-top:10px;"></div>
    
    <!-- Enviar para Telegram -->
<label class="flex items-center gap-2 mt-3 cursor-pointer">
    <input type="checkbox" id="enviarTelegram"
           class="w-5 h-5 accent-[var(--accent)] cursor-pointer">
    <span class="text-sm">Enviar este aviso para o Telegram</span>
</label>

<label class="flex items-center gap-2 mt-3 cursor-pointer">
    <input type="checkbox" id="salvarPadrao"
           class="w-5 h-5 accent-[var(--accent)] cursor-pointer">
    <span class="text-sm">Usar mensagens para outros avisos</span>
</label>

    <!-- Botão Salvar -->
    <button id="salvarAviso" class="w-full mt-4 py-3 rounded-2xl font-semibold text-[var(--header-text)] transition-all duration-300 hover:scale-105 hover:shadow-lg" style="background:var(--accent);">
        Salvar Aviso
    </button>
</div>

        <!-- LISTAGEM DE AVISOS -->
<div>
    <h2 class="text-xl font-semibold mb-2">Avisos Criados</h2>
    <div id="listaAvisos" class="grid gap-4 grid-cols-2 md:grid-cols-4 xl:grid-cols-5">
    <?php foreach($avisos as $a): ?>
<div class="p-2 rounded-xl border bg-[var(--menu-secondary)] flex flex-col items-center" style="border-color:var(--border-color);">
    <!-- Título e Descrição Opcionais -->
    <?php if(isset($a['titulo_opcional'])): ?>
        <strong class="text-center text-lg mb-1"><?= htmlspecialchars($a['titulo_opcional']) ?></strong>
    

<?php if(isset($a['imagem']) && empty($a['conteudo'])): ?>
    <?php 
        $ext = pathinfo($a['imagem'], PATHINFO_EXTENSION);
        $videoExts = ['mp4','webm','ogg']; 
    ?>
    <?php if(in_array(strtolower($ext), $videoExts)): ?>
        <video controls class="w-full rounded mb-2" style="max-height:240px; background:#000;">
            <source src="uploads/<?= htmlspecialchars($a['imagem']) ?>" type="video/<?= $ext ?>">
            Seu navegador não suporta vídeo.
        </video>
    <?php else: ?>
        <img src="uploads/<?= htmlspecialchars($a['imagem']) ?>" class="w-full rounded mb-2" style="object-fit:contain; max-height:240px; background:#000;">
    <?php endif; ?>
<?php endif; ?>

<?php endif; ?>
    <?php if(isset($a['descricao_opcional'])): ?>
        <small class="text-center mb-2"><?= htmlspecialchars($a['descricao_opcional']) ?></small>
    <?php endif; ?>

<?php if(empty($a['conteudo'])): ?>
    <?php if(!empty($a['botao_nome_opcional']) && !empty($a['link_opcional'])): ?>
        <button onclick="window.open('<?= htmlspecialchars($a['link_opcional']) ?>','_blank')"
            class="mt-2 px-2 py-1 rounded text-white w-full"
            style="background:var(--accent);">
            <?= htmlspecialchars($a['botao_nome_opcional']) ?>
        </button>
    <?php elseif(!empty($a['botao_nome_opcional'])): ?>
        <button class="mt-2 px-2 py-1 rounded text-white w-full"
            style="background:var(--accent);">
            <?= htmlspecialchars($a['botao_nome_opcional']) ?>
        </button>
    <?php endif; ?>
<?php endif; ?>



    <?php if(isset($a['conteudo'])): ?>
        <?php foreach($a['conteudo'] as $c): ?>
        <div class="border rounded p-2 mb-2 w-full flex flex-col items-center">
            <?php
                // Tenta usar o novo campo link_capa, se não existir, tenta o antigo poster_path
                $poster = $c['link_capa'] ?? (isset($c['poster_path']) && $c['poster_path']
                    ? "https://image.tmdb.org/t/p/w500".$c['poster_path']
                    : 'https://via.placeholder.com/300x450?text=Sem+Capa');
            ?>
            <img src="<?= $poster ?>" class="w-full rounded mb-1" style="object-fit:contain; max-height:240px; background:#000;">
            <strong class="text-center"><?= $c['nome']??$c['title']??$c['name'] ?></strong><br>
            
            <?php if(isset($c['sinopse'])): ?>
                <small>Sinopse: <?= substr($c['sinopse'], 0, 100) . (strlen($c['sinopse']) > 100 ? '...' : '') ?></small><br>
            <?php endif; ?>

            <?php if(isset($c['categorias'])): ?>
                <small>🏷️Categorias: <?= $c['categorias'] ?></small><br>
            <?php endif; ?>

            <?php if(!empty($c['botao_nome_opcional']) && !empty($c['link_opcional'])): ?>
    <button onclick="window.open('<?= htmlspecialchars($c['link_opcional']) ?>','_blank')"
        class="mt-2 px-2 py-1 rounded text-white w-full"
        style="background:var(--accent);">
        <?= htmlspecialchars($c['botao_nome_opcional']) ?>
    </button>
<?php endif; ?>

            <?php if(isset($c['seasons']) && !empty($c['episodios_selecionados'])): ?>
    <small class="opacity-75 block mb-1">
        🗂️Temporadas: <?= count(array_unique(array_map(fn($e)=>intval(substr($e,1,1)), $c['episodios_selecionados']))) ?>
    </small>
    <small class="opacity-75 block mb-1">
        🎬Episódios: <?= count($c['episodios_selecionados']) ?>
    </small>
<?php endif; ?>

<?php if(isset($a['rodape_opcional'])): ?>
    <small class="text-center opacity-70 mb-2"><?= htmlspecialchars($a['rodape_opcional']) ?></small>
<?php endif; ?>
        </div>
        <?php endforeach; ?>
    <?php endif; ?>

    <button onclick="deletarAviso('<?= $a['id'] ?>')" class="mt-2 px-2 py-1 rounded text-white w-full" style="background:#d9534f;">Deletar</button>
</div>
<?php endforeach; ?>
</div>

<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
const apiKey = "770db45f364961cbab3bbe17bc79687b";
const tipoAviso = document.getElementById("tipoAviso");
const normalForm = document.getElementById("normalForm");
const tituloOpcional = document.getElementById("tituloOpcional");
const descOpcional = document.getElementById("descOpcional");
const linkOpcional = document.getElementById("linkOpcional");
const tmdbForm = document.getElementById("tmdbForm");
const buscaTMDB = document.getElementById("buscaTMDB");
const resultadoTMDB = document.getElementById("resultadoTMDB");
const seriesSeasons = document.getElementById("seriesSeasons");
const preVisual = document.getElementById("preVisual");
let tmdbSelecionado = null;

/* ===== GARANTIA DE MODO PADRÃO (SEM ALTERAR FLUXO) ===== */
seriesSeasons.dataset.modo = "seasons";

tipoAviso.addEventListener("change",()=>{
    if(tipoAviso.value==="normal"){
        normalForm.style.display="block";
        tmdbForm.style.display="none";
        seriesSeasons.style.display="none";
        resultadoTMDB.innerHTML="";
        preVisual.style.display="none";
    }else{
        normalForm.style.display="none";
        tmdbForm.style.display="block";
        resultadoTMDB.innerHTML="";
        seriesSeasons.style.display="none";
        preVisual.style.display="none";
    }
});

let timer;
buscaTMDB.addEventListener("input",()=>{
    clearTimeout(timer);
    if(buscaTMDB.value.length<3) return resultadoTMDB.innerHTML="";
    timer=setTimeout(async()=>{
        const tipo=tipoAviso.value;
        const url=`https://api.themoviedb.org/3/search/${tipo==='filme'?'movie':'tv'}?api_key=${apiKey}&language=pt-BR&query=${encodeURIComponent(buscaTMDB.value)}`;
        const res=await fetch(url);
        const data=await res.json();
        resultadoTMDB.innerHTML="";
        data.results.forEach(item=>{
            const img=item.poster_path?`https://image.tmdb.org/t/p/w300${item.poster_path}`:'https://via.placeholder.com/300x450?text=Sem+Capa';
            const div=document.createElement("div");
            div.className="border rounded p-2 cursor-pointer relative transition-all duration-300 ease-in-out transform hover:scale-[1.02] hover:shadow-lg flex flex-col items-center text-center";
            div.innerHTML=`
                <div class="w-full h-56 mb-2 flex items-center justify-center bg-gray-800 rounded">
                    <img src="${img}" class="h-full rounded" style="object-fit:contain; background:#000;">
                </div>
                <strong class="text-sm font-bold">${item.title||item.name}</strong>
                <small class="text-xs opacity-70">${tipo==='filme'?item.release_date:item.first_air_date}</small>
            `;
            div.onclick = async()=>{
                resultadoTMDB.innerHTML="";
                tmdbSelecionado=item;
                buscaTMDB.value=item.title||item.name;

                const detUrl = tipo==='filme'
                    ? `https://api.themoviedb.org/3/movie/${item.id}?api_key=${apiKey}&language=pt-BR`
                    : `https://api.themoviedb.org/3/tv/${item.id}?api_key=${apiKey}&language=pt-BR`;

                const det=await fetch(detUrl).then(r=>r.json());
                tmdbSelecionado=det;

                preVisual.innerHTML=`
                    <div class="flex flex-col md:flex-row gap-4">
                        <img src="${det.poster_path?`https://image.tmdb.org/t/p/w300${det.poster_path}`:'https://via.placeholder.com/300x450?text=Sem+Capa'}"
                             class="w-full rounded mb-2 md:w-48 md:h-72 md:mb-0 flex-shrink-0"
                             style="object-fit:contain; background:#000;">
                        <div>
                            <h3 class="text-xl font-bold">${det.title||det.name}</h3>
                            <small>Lançamento: ${det.release_date||det.first_air_date}</small><br>
                            <small>Categorias: ${det.genres.map(g=>g.name).join(", ")}</small><br>
                            <small>Avaliação: ${det.vote_average}</small><br>
                            <p class="mt-2">${det.overview||''}</p>
                        </div>
                    </div>
                `;
                preVisual.style.display="block";

                if(tipo==='serie'){
                    seriesSeasons.innerHTML="<h3 class='text-lg font-semibold mb-3'>Seleção de Temporadas e Episódios</h3>";
                    seriesSeasons.dataset.modo = "seasons";

                    let selectAllSeries = document.createElement("button");
                    selectAllSeries.className = "w-full mb-3 px-4 py-3 rounded-2xl font-semibold text-white text-center";
                    selectAllSeries.style.background = "var(--accent)";
                    selectAllSeries.innerText = "Selecionar série completa";
                    selectAllSeries.onclick = () =>
                        document.querySelectorAll(".ep_checkbox").forEach(cb => cb.checked = true);

                    seriesSeasons.appendChild(selectAllSeries);

                    det.seasons.forEach(season=>{
                        if(season.season_number === 0) return;

                        let seasonDiv=document.createElement("div");
                        seasonDiv.className="border p-3 rounded mb-3";
                        seasonDiv.innerHTML=`<strong>Temporada ${season.season_number}</strong><br>`;

                        let selectSeasonBtn=document.createElement("button");
                        selectSeasonBtn.className="mr-3 px-2 py-1 rounded text-xs border";
                        selectSeasonBtn.innerText="Temporada completa";
                        selectSeasonBtn.onclick=()=>seasonDiv.querySelectorAll(".ep_checkbox").forEach(cb=>cb.checked=true);

                        seasonDiv.appendChild(selectSeasonBtn);

                        for(let ep=1;ep<=season.episode_count;ep++){
                            let lbl=document.createElement("label");
                            lbl.className="mr-3 block";
                            lbl.innerHTML=`<input type="checkbox" class="ep_checkbox" data-season="${season.season_number}" value="${ep}"> Ep ${ep}`;
                            seasonDiv.appendChild(lbl);
                        }

                        seriesSeasons.appendChild(seasonDiv);
                    });

                    seriesSeasons.style.display="block";
                }
            };
            resultadoTMDB.appendChild(div);
        });
    },500);
});

document.getElementById("salvarAviso").addEventListener("click",async()=>{
    const tipo=tipoAviso.value;
    const formData=new FormData();
    formData.append("tipo",tipo);
    formData.append("enviar_telegram", document.getElementById("enviarTelegram").checked ? "1" : "0");

    const rodapeOpcionalValor = document.getElementById("rodapeOpcional").value;
    const botaoNomeOpcionalValor = document.getElementById("botaoNomeOpcional").value;

    if(tituloOpcional.value) formData.append("titulo_opcional",tituloOpcional.value);
    if(descOpcional.value) formData.append("descricao_opcional",descOpcional.value);
    if(linkOpcional.value) formData.append("link_opcional",linkOpcional.value);
    if(rodapeOpcionalValor) formData.append("rodape_opcional",rodapeOpcionalValor);
    if(botaoNomeOpcionalValor) formData.append("botao_nome_opcional",botaoNomeOpcionalValor);

    if(tipo==="normal"){
        const file=document.getElementById("arquivoNormal").files[0];
        if(file) formData.append("arquivo",file);
    }else{
        if(!tmdbSelecionado) return Swal.fire("Erro","Selecione um conteúdo","error");

        let conteudoFiltrado = {
            nome: tmdbSelecionado.title || tmdbSelecionado.name,
            sinopse: tmdbSelecionado.overview,
            link_capa: tmdbSelecionado.poster_path ? `https://image.tmdb.org/t/p/w500${tmdbSelecionado.poster_path}` : null,
            categorias: tmdbSelecionado.genres.map(g=>g.name).join(", "),
            link_opcional: linkOpcional.value || "",
            rodape_opcional: rodapeOpcionalValor || "",
            botao_nome_opcional: botaoNomeOpcionalValor || ""
        };

        if(tipo==="serie"){
            conteudoFiltrado.episodios = Array.from(document.querySelectorAll(".ep_checkbox:checked"))
                .map(i => ({ grupo: i.dataset.season, episodio: i.value }));

            conteudoFiltrado.modo = seriesSeasons.dataset.modo || "seasons";
            conteudoFiltrado.seasons = tmdbSelecionado.seasons.map(s => ({
                season_number: s.season_number,
                episode_count: s.episode_count
            }));
        }

        formData.append("conteudo",JSON.stringify([conteudoFiltrado]));
    }

    const res=await fetch("avisos_save.php",{method:"POST",body:formData});
    const json=await res.json();
    if(json.success) Swal.fire("Sucesso","Aviso salvo","success").then(()=>location.reload());
    else Swal.fire("Erro",json.msg||"Falha ao salvar","error");
});

/* ===== MENSAGENS PADRÃO ===== */
const padraoCampos = {
    titulo: localStorage.getItem("padrao_titulo") || "",
    descricao: localStorage.getItem("padrao_descricao") || "",
    botao: localStorage.getItem("padrao_botao") || "",
    rodape: localStorage.getItem("padrao_rodape") || ""
};

tituloOpcional.value = padraoCampos.titulo;
descOpcional.value = padraoCampos.descricao;
document.getElementById("botaoNomeOpcional").value = padraoCampos.botao;
document.getElementById("rodapeOpcional").value = padraoCampos.rodape;

document.getElementById("salvarPadrao").addEventListener("change", function () {
    if (this.checked) {
        localStorage.setItem("padrao_titulo", tituloOpcional.value);
        localStorage.setItem("padrao_descricao", descOpcional.value);
        localStorage.setItem("padrao_botao", document.getElementById("botaoNomeOpcional").value);
        localStorage.setItem("padrao_rodape", document.getElementById("rodapeOpcional").value);
    }
});
</script>