<?php
session_start();
include "includes/header.php";

$avisosFile = __DIR__ . "/admin/avisos/avisos.json";
$avisos = [];

if (file_exists($avisosFile)) {
    $raw = file_get_contents($avisosFile);
    $avisos = json_decode($raw, true);
    if (!is_array($avisos)) $avisos = [];
}
?>

<main class="pt-24 px-4 min-h-screen bg-[var(--body-bg)]">

    <h1 class="text-3xl font-bold text-center mb-8" style="color:var(--text-primary);">
        <i class="fa-solid fa-bullhorn mr-2"></i> Avisos
    </h1>

    <div class="max-w-5xl mx-auto space-y-8">

        <?php foreach ($avisos as $a): ?>

            <!-- CARD -->
            <div class="rounded-2xl shadow-xl p-6 border"
                 style="background:var(--menu-bg); border-color:var(--border-color); color:var(--text-primary);">

                <!-- TÍTULO -->
                <h2 class="text-xl font-semibold flex items-center gap-2 mb-2">
                    <?php if ($a['tipo'] === 'serie'): ?>
                        <i class="fa-solid fa-clapperboard text-red-500"></i>
                    <?php elseif ($a['tipo'] === 'filme'): ?>
                        <i class="fa-solid fa-film text-yellow-400"></i>
                    <?php else: ?>
                        <i class="fa-solid fa-circle-exclamation text-blue-400"></i>
                    <?php endif; ?>
                    <?= strtoupper(htmlspecialchars($a['titulo_opcional'] ?? 'AVISO')) ?>
                </h2>

                <!-- DESCRIÇÃO DO AVISO (SOMENTE UMA VEZ) -->
                <?php if (!empty($a['descricao_opcional']) && $a['tipo'] !== 'normal'): ?>
                    <p class="text-sm opacity-80 mb-4">
                        <?= htmlspecialchars($a['descricao_opcional']) ?>
                    </p>
                <?php endif; ?>

                <!-- ============================
                     AVISO NORMAL
                ================================ -->
                <?php if ($a['tipo'] === 'normal'): ?>

                    <div class="flex flex-col md:flex-row gap-6 mt-4">

                        <!-- IMAGEM -->
                        <img src="admin/uploads/<?= htmlspecialchars($a['imagem']) ?>"
                             class="rounded-xl shadow w-full md:w-1/3 object-cover border"
                             style="border-color:var(--border-color)">
                        
                        <!-- DESCRIÇÃO DO AVISO NORMAL -->
                        <div class="flex-1 text-sm opacity-90">
                            <?php if (!empty($a['descricao_opcional'])): ?>
                                <p class="mb-3"><?= htmlspecialchars($a['descricao_opcional']) ?></p>
                            <?php endif; ?>

                            <?php if (!empty($a['link_opcional'])): ?>
                                <a href="<?= htmlspecialchars($a['link_opcional']) ?>" 
                                   target="_blank"
                                   class="text-blue-400 underline text-sm">
                                    <i class="fa-solid fa-link mr-1"></i> Acessar
                                </a>
                            <?php endif; ?>
                        </div>

                    </div>

                <?php endif; ?>

                <!-- ============================
                     FILME / SÉRIE
                ================================ -->

                <?php if (!empty($a['conteudo'])): ?>
                    <?php foreach ($a['conteudo'] as $c): ?>

                        <div class="mt-6 p-4 rounded-xl border"
                             style="background:var(--menu-secondary); border-color:var(--border-color);">

                            <div class="flex flex-col md:flex-row gap-6">

                                <!-- CAPA -->
                                <?php if (!empty($c['link_capa'])): ?>
                                    <img src="<?= htmlspecialchars($c['link_capa']) ?>"
                                         class="rounded-xl shadow w-full md:w-1/3 object-cover">
                                <?php endif; ?>

                                <div class="flex-1">

                                    <h3 class="text-xl font-bold mb-1">
                                        <?= htmlspecialchars($c['nome']) ?>
                                    </h3>

                                    <p class="text-sm opacity-90 mb-3">
                                        <?= htmlspecialchars($c['sinopse']) ?>
                                    </p>

                                    <!-- categorias -->
                                    <?php if (!empty($c['categorias'])): ?>
                                        <p class="text-xs mb-3 opacity-80">
                                            <i class="fa-solid fa-tags mr-1"></i>
                                            <?= is_array($c['categorias']) ? implode(", ", $c['categorias']) : $c['categorias'] ?>
                                        </p>
                                    <?php endif; ?>

                                    <!-- link ÚNICO -->
                                    <?php if (!empty($c['link_opcional'])): ?>
                                        <a href="<?= htmlspecialchars($c['link_opcional']) ?>" 
                                           target="_blank"
                                           class="text-blue-400 underline text-sm">
                                           <i class="fa-solid fa-arrow-up-right-from-square mr-1"></i> Acessar
                                        </a>
                                    <?php endif; ?>

                                    <!-- episódios -->
                                    <?php if (!empty($c['episodios_selecionados'])): ?>
                                        <p class="font-semibold mt-4">Episódios:</p>
                                        <div class="flex flex-wrap gap-2 mt-1">
                                            <?php foreach ($c['episodios_selecionados'] as $ep): ?>
                                                <span class="px-3 py-1 text-xs rounded-xl"
                                                      style="background:var(--menu-bg); border:1px solid var(--border-color);">
                                                      <?= htmlspecialchars($ep) ?>
                                                </span>
                                            <?php endforeach; ?>
                                        </div>
                                    <?php endif; ?>

                                    <!-- temporadas -->
                                    <?php if (!empty($c['seasons'])): ?>
                                        <p class="font-semibold mt-4">Temporadas:</p>
                                        <ul class="text-sm opacity-80 space-y-1">
                                            <?php foreach ($c['seasons'] as $s): ?>
                                                <li>
                                                    Temporada <?= $s['season_number'] ?> — <?= $s['episode_count'] ?> episódios
                                                </li>
                                            <?php endforeach; ?>
                                        </ul>
                                    <?php endif; ?>

                                </div>
                            </div>
                        </div>

                    <?php endforeach; ?>
                <?php endif; ?>

            </div>

        <?php endforeach; ?>
    </div>
</main>